

black='\E[30;50m'
red='\E[31;50m'
green='\E[32;50m'
yellow='\E[33;50m'
blue='\E[34;50m'
magenta='\E[35;50m'
cyan='\E[36;50m'
white='\E[37;50m'

bold='\033[1m'
color_print=1


function disable_color_print()
{
	color_print=0
}


function enable_color_print()
{
	color_print=1
}

# cecho (color echo) prints text in color.
# first parameter should be the desired color followed by text
function cecho ()
{
	if [ ${color_print} -eq 0 ]
	then
		shift
		echo $*
	else
		echo -en $1
		shift
		echo $*
		tput sgr0
	fi
}

# becho (color echo) prints text in bold.
becho ()
{
	if [ $color_print -eq 0 ]
	then
		echo $*
		return
	fi
	echo -en $bold
	echo $*
	tput sgr0
}

function get_yn()
{
	yn=$defyn
	while [ -z $yn ]
	do
		read -p "$* [yn]:" yn
		[ ! -z $yn ] && [ $yn != y ] && [ $yn != n ] && yn=''
	done
}

function fatal()
{
	if [ $color_print -eq 0 ]
	then
		echo FATAL: $*
		return
	fi
	echo -en $red
	echo FATAL: $*
	tput sgr0
	exit 1
}

function error()
{
	if [ $color_print -eq 0 ]
	then
		echo ERROR: $*
		return
	fi
	echo -en $red
	echo ERROR: $*
	tput sgr0
}

function warning()
{
	if [ $color_print -eq 0 ]
	then
		echo WARNING: $*
		return
	fi
	echo -en $yellow
	echo WARNING: $*
	tput sgr0
}

function info()
{
	becho INFO: $*
}

function info_red()
{
	if [ $color_print -eq 0 ]
	then
		info $*
		return
	fi
	echo -ne $red
	echo INFO: $*
	tput sgr0
}

function info_green()
{
	if [ $color_print -eq 0 ]
	then
	      info $*
	      return
	fi
	echo -ne $green
	echo INFO: $*
	tput sgr0
}

function success()
{
	if [ $color_print -eq 0 ]
	then
	      echo : OK: $*
	      return
	fi
	echo -en $green
	echo OK: $*
	tput sgr0
}

function failure()
{
	if [ $color_print -eq 0 ]
	then
		echo FAILED: $*
		return
	fi
	echo -en $red
	echo FAILED: $*
	tput sgr0
}

function header()
{
	echo  "============================================================"
	echo $*
	echo  "============================================================"
}

function get_val_or_null()
{
	val=""
	read -p "$* : " val
}

function get_val()
{
	val=""
	if [ "$1" = "-d" ]
	then
		default=$2
		shift 2
	fi
	while [ -z $val ]
	do
		read -p "$* [$default]: " val
		[ -z $val ] && [ -n $default ] && val=$default
	done
}

[ -f /etc/redhat-release -o -f /etc/chaos-release -o -f /etc/rocks-release ] && \
	linux_dist=redhat && netscript_dir=/etc/sysconfig/network-scripts/
[ -f /etc/SuSE-release -o -f /etc/UnitedLinux-release ] && \
	linux_dist=suse && netscript_dir=/etc/sysconfig/network/
[ -z $linux_dist ] && linux_dist=unknown && netscript_dir=/tmp

#
# print an error and exit, stating the log file
#
function die_log()
{
	error "$@"
	info_red See $LOG
	exit 1
}

#
# print an error and exit, stating the log file
#
function die()
{
	error "$@"
	exit 1
}

#
# execute a command and put it's stdout and stderr to the log file
#
function ex()
{
	[ -z $LOG ] && LOG=$(tty)
	echo Running $@
	eval "$@" >> $LOG 2>&1
	return $?	
}
